module printExample1

//********************************************************************************
//  Clean tutorial example program.
//
//  This program demonstrates the use of the "print" function.
//  It prints two pages, one with the text "Hello Printer", and one, that informs
//  about the printer's resolution.
//********************************************************************************

import StdEnv, StdPrint, StdPicture

Start world
    # (defaultPS, world) = defaultPrintSetup world
    = snd (accFiles (print True False pages defaultPS) world)
  where
    pages :: PrintInfo *Picture -> ([IdFun *Picture],*Picture)
    pages { printSetup, jobInfo={ range=(first,last), copies } } picture
      # {resolution=(xRes,_)} = getPageDimensions printSetup False
        bothPages
            = [ drawAt { x=100, y=100 } "Hello Printer",
                drawAt { x=100, y=200 }
                       ("horizontal Resolution: "+++toString xRes
                                                 +++" dpi.") ]
        oneCopy = bothPages % (first-1,last-1)
      = ( flatten (repeatn copies oneCopy), picture)

